#ifndef DISPLAY_H_
#define DISPLAY_H_

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_conf.h"

/* Exported types ------------------------------------------------------------*/
typedef enum
{
	DISPLAY_Calibrating,
	DISPLAY_Normal,
	DISPLAY_SettingTime,
	DISPLAY_SettingAlarm

} display_State;

/* Exported function prototypes ----------------------------------------------*/

// Display_Init()
// --------------
// Initialize the display module.
extern void Display_Init();

// Display_Update()
// ----------------
// Send the I2C command to update the display.
extern void Display_Update();

// Display_SetState()
// ------------------
// Set the current state of the display.
extern void Display_SetState(display_State state);

// Display_SetTime()
// -----------------
// Set the time to display when in the Normal or SettingTime state.
extern void Display_SetTime(uint32_t time);

// Display_SetAlarm()
// ------------------
// Set the value to display when in the SettingAlarm state.
extern void Display_SetAlarm(uint32_t time);

// Display_EnableAlarm()
// ---------------------
// Show or disable the alarm indicator.
extern void Display_EnableAlarm(bool enabled);

#endif /* DISPLAY_H_ */
